package IRC;


use Symbol qw(gensym);
use base 'CL::Socket';

my IRC $irc_socket=undef;
my $irc_socket_conn=0;
my $show_output=1;

sub timestamp($) {
  print $logfile "######## ",scalar localtime,":: ",$_[0],"\n" if $logfilename;
}

sub write_log($) {
    print $logfile "$_[0]\n" if ($logfilename);
}

sub logopen(;$) {
  if ($logfilename) {
    my $tmp=$logfilename;
    timestamp("Closing log file.");
    close($logfile);
    $logfile=undef;
    $logfilename=undef;
    CL::msg("Stopped logging to {$tmp}.");
  }
  return if ($#_<0);
  my $f=shift;
  $logfile=gensym();
  if (open($logfile,">>$f")) {
    CL::msg("Logging to {$f}.");
    $logfilename=$f;
    timestamp("Opened log file.");
  } else {
    CL::err("Can't open {$f}.");
  }
}
 
sub new {
  my $class=shift;
  CL::msg("Connecting to IRC server $_[0]:$_[1]...");
  $class->SUPER::new($_[0],$_[1]);
}

sub conn($$;$) {
  $irc_socket->close if ($irc_socket);
  $irc_socket=undef;
  $irc_socket_conn=0;
  $irc_socket=new IRC(@_);
}

sub disconn() {
  return if (!$irc_socket);
  $irc_socket->close();
}

sub print($) {
  $irc_socket->writeln("$_[0]");
}

sub ext_print($$) {
  local($line)=shift;
  local($line2)=shift;
  $irc_socket->writeln(__c2ic("$line"));
  $l_m=CL::parse_colors(__c2mc("$line2"));
  $l_n=CL::parse_colors(__c2nc("$line2"));
  if ($show_output) { CL::toutput(0,$l_m); }
  CL::toutput(1,$l_m);
  write_log(CL::strip_colors($l_n));
}

sub closed($) {
  my IRC $self=shift;
  CL::msg("$self->{rh}:$self->{rp}: connection closed.");
  $irc_socket=undef;
}

sub remclosed($) {
  my IRC $self=shift;
  CL::msg("$self->{rh}:$self->{rp}: connection closed by IRC server.");
  $irc_socket=undef;
}

sub echo($$) {
  my IRC $self=shift;
  my $e=shift;
  LE::echo($e);
}

sub bell($) {
  my IRC $self=shift;
  ::sndevent("MudBeep");
}

sub connected($$) {
  my IRC $self=shift;
  CL::msg("Connected to IRC server $self->{rh}:$self->{rp}.");
  $irc_socket=$self;
  $irc_socket_conn=1;
}

@mmc_colors=('P','H','E','C','J','B','F','D','L','K','G','O','M','N','I','H');

sub __c2mc($) {
  $line=shift;
  while ($line=~/__(\d+)/) {
    $n=$1;
    $line=~s/__$n/\003$mmc_colors[$n]/g;
  }
  return $line;
}

sub __c2ic($) {
  $line=~s/__/\003/g;
  return $line;
}

sub __c2nc($) {
  $line=~s/__(\d+)//g;
  return $line;
}

sub line($$) {
  my IRC $self=shift;
  my $cline=shift;
  my $line=CL::strip_colors($cline);

  if ($line =~ /^PING (\S+)/) {
    $irc_socket->writeln("PONG $1");
    $fin_line="PING? PONG!"; 
  } elsif ($line =~ /^:(\S+)!(\S.*?)\sPRIVMSG\s(\S+)\s:(.*)/) {
    $fin_line="\003L[IRC] \003C$1 -> $3: $4";
  } elsif ($line =~ /^:(\S+)!(\S.*?)\sNOTICE\s(\S+)\s:(.*)/) {
    $fin_line="\003L[IRC] \003B$1 -> $3: $4";
  } elsif ($line =~ /^:(\S+)!(\S.*?)\sJOIN\s:(\S+)/) {
    $fin_line="\003C$1($2) JOINED $3";
  } elsif ($line =~ /^:(\S+)!(\S.*?)\sPART\s(\S+)\s:(.*)/) {
    $fin_line="\003C$1($2) LEFT $3($4)";
  } elsif ($line =~ /^:(\S+)!(\S.*?)\sQUIT\s(\S+)\s:(.*)/) {
    $fin_line="\003C$1($2) QUIT IRC($3)";
  } elsif ($line =~ /^:(\S+)\s(\d+)\s(\S+)\s(.*)/) {
    $fin_line="$2 $4";
  } else {
    $fin_line="$line";
  }

  if ($fin_line) {
    if ($show_output) { CL::toutput(0,CL::parse_colors($fin_line)); }
    CL::toutput(1,CL::parse_colors($fin_line));
    write_log("$fin_line");
  } 

}

sub prompt($$) {
  my IRC $self=shift;
  my $prompt=shift;
  line($self,$prompt);
}



1;
